#version 140
#extension GL_EXT_gpu_shader4 : enable
//The marshmallow cloud machineMod01.fsh by 42yeah
//https://www.shadertoy.com/view/3tcSWj
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159265


vec2 skew(vec2 uv, float deg) {
    return vec2(uv.x + cos(uv.y), uv.y);
}

vec2 rot2d(vec2 uv, float deg) {
    return vec2(cos(deg) * uv.x - sin(deg) * uv.y,
                sin(deg) * uv.x + cos(deg) * uv.y);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy / iResolution.xy * 2.0 - 1.0;

    float aspect = iResolution.x / iResolution.y;
    uv.x *= aspect;

    vec2 p = uv * 3.0;

    float l = length(p + sin(iTime));
    p = rot2d(p, iTime * 0.5);
    p = rot2d(p, l * 0.6);
    p = skew(p, l * 2.0 + 0.5);

    vec2 f = fract(p);
    f = rot2d(f, l * 2.0);
    vec3 blueness = mix(vec3(0.2, 0.4, 0.7), vec3(1.0, 1.0, 1.0), length(f));

    // Output to screen
    gl_FragColor = vec4(blueness, 1.0);
}